/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.schedulers;

import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.NonNull;
import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.Nullable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Scheduler;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.DisposableContainer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.schedulers.InstantPeriodicTask;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.schedulers.ScheduledDirectPeriodicTask;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.schedulers.ScheduledDirectTask;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.schedulers.ScheduledRunnable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.schedulers.SchedulerPoolFactory;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NewThreadWorker
extends Scheduler.Worker
implements Disposable {
    private final ScheduledExecutorService executor;
    volatile boolean disposed;

    public NewThreadWorker(ThreadFactory threadFactory) {
        this.executor = SchedulerPoolFactory.create(threadFactory);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable run) {
        return this.schedule(run, 0L, null);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        return this.scheduleActual(action, delayTime, unit, null);
    }

    public Disposable scheduleDirect(Runnable run, long delayTime, TimeUnit unit) {
        ScheduledDirectTask task = new ScheduledDirectTask(RxJavaPlugins.onSchedule(run), true);
        try {
            Future<Void> f = delayTime <= 0L ? this.executor.submit(task) : this.executor.schedule(task, delayTime, unit);
            task.setFuture(f);
            return task;
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        if (period <= 0L) {
            InstantPeriodicTask periodicWrapper = new InstantPeriodicTask(decoratedRun, this.executor);
            try {
                Future<Void> f = initialDelay <= 0L ? this.executor.submit(periodicWrapper) : this.executor.schedule(periodicWrapper, initialDelay, unit);
                periodicWrapper.setFirst(f);
            }
            catch (RejectedExecutionException ex) {
                RxJavaPlugins.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
            return periodicWrapper;
        }
        ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun, true);
        try {
            ScheduledFuture<?> f = this.executor.scheduleAtFixedRate(task, initialDelay, period, unit);
            task.setFuture(f);
            return task;
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @NonNull
    public ScheduledRunnable scheduleActual(Runnable run, long delayTime, @NonNull TimeUnit unit, @Nullable DisposableContainer parent) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        ScheduledRunnable sr = new ScheduledRunnable(decoratedRun, parent);
        if (parent != null && !parent.add(sr)) {
            return sr;
        }
        try {
            Future<Object> f = delayTime <= 0L ? this.executor.submit(sr) : this.executor.schedule(sr, delayTime, unit);
            sr.setFuture(f);
        }
        catch (RejectedExecutionException ex) {
            if (parent != null) {
                parent.remove(sr);
            }
            RxJavaPlugins.onError(ex);
        }
        return sr;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdownNow();
        }
    }

    public void shutdown() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdown();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

